package ga.view.appstate.menu;

/**
 * Listener for menu events. Allows states to communicate back to the main menu.
 * 
 * @since 12.08.2012
 * @author Stephan Dreyer
 */
public interface MenuListener {
  /**
   * Callback when a model has been selected.
   * 
   * @param name
   *          Name of the model, must be unique.
   * 
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  public void modelSelected(String name);

  /**
   * Callback when a state is exited.
   * 
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  public void backToMenu();

  /**
   * Callback when the next state should be attached.
   * 
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  public void nextState();
}
